#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <map>
#include <set>
#include <algorithm>

using namespace std;

const int MAXN = 20 * 1000 + 5, MAXM = 100 * 1000 + 5, INF = 2000 * 1000 * 1000 + 5;
int d[MAXN], tin[MAXN], f[MAXN], t;
char used[MAXN], good[MAXM], br[MAXN];
vector< pair<int, pair<int, int> > > g[MAXN];
set< pair<int, int> > st;
vector<int> ans;

void dfs(int v, int p) {
    used[v] = true;
    tin[v] = t++;
    f[v] = tin[v];
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, id = g[v][i].second.second;
        if(!good[id] || id == p)
            continue;
        if(used[u])
            f[v] = min(f[v], tin[u]);
        else {
            dfs(u, id);
            if(f[u] > tin[v])
                br[id] = true;
            f[v] = min(f[v], f[u]);
        }
    }
}

bool getPath(int v, int t) {
    used[v] = true;
    if(v == t)
        return true;
    for(size_t i = 0; i < g[v].size(); i++) {
        int u = g[v][i].first, id = g[v][i].second.second;
        if(!good[id] || used[u])
            continue;
        if(getPath(u, t)) {
            if(br[id])
                ans.push_back(id);
            return true;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    int n, m;
    cin >> n >> m;
    for(int i = 0; i < m; i++) {
        int v, u, w;
        cin >> v >> u >> w;
        v--;
        u--;
        g[v].push_back(make_pair(u, make_pair(w, i)));
        g[u].push_back(make_pair(v, make_pair(w, i)));
    }
    for(int i = 0; i < n; i++)
        d[i] = INF;
    d[0] = 0;
    st.insert(make_pair(d[0], 0));
    while(!st.empty()) {
        int v = st.begin()->second;
        st.erase(st.begin());
        for(size_t i = 0; i < g[v].size(); i++) {
            int u = g[v][i].first, w = g[v][i].second.first;
            if(d[v] + w < d[u]) {
                st.erase(make_pair(d[u], u));
                d[u] = d[v] + w;
                st.insert(make_pair(d[u], u));
            }
        }
    }
    for(int i = 0; i < n; i++)
        for(size_t j = 0; j < g[i].size(); j++) {
            int u = g[i][j].first, w = g[i][j].second.first, id = g[i][j].second.second;
            if(d[i] + w == d[u])
                good[id] = true;
        }
    dfs(0, -1);
    for(int i = 0; i < n; i++)
        used[i] = false;
    getPath(0, n - 1);
    cout << ans.size() << '\n';
    for(size_t i = 0; i < ans.size(); i++)
        cout << ans[i] + 1 << ' ';
    cout << '\n';
    return 0;
}
